#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from onf_website.reference.insee.model import Departement, Commune
from onf_website.reference.insee.schema import ICommuneField, IDepartmentField
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.shared.form.interfaces import IFormFieldDataConverter
from pyams_utils.adapter import adapter_config, ContextRequestAdapter


__docformat__ = 'restructuredtext'


@adapter_config(context=(IDepartmentField, IONFBaseLayer), provides=IFormFieldDataConverter)
class DepartmentFielddataConverter(ContextRequestAdapter):
    """Department field data converter"""

    @staticmethod
    def convert(value):
        if value:
            department = Departement.find_by_insee_code(value).first()
            if department is not None:
                value = department.title
        return value


@adapter_config(context=(ICommuneField, IONFBaseLayer), provides=IFormFieldDataConverter)
class CommuneFieldDataConverter(ContextRequestAdapter):
    """Commune field data converter"""

    @staticmethod
    def convert(value):
        if value:
            commune = Commune.find_by_insee_code(value).first()
            if commune is not None:
                value = '{} ({})'.format(commune.title_enr, commune.dep)
        return value
