#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyramid_rpc.jsonrpc import jsonrpc_method
from sqlalchemy.sql import and_, or_

from onf_website.reference.forest import IForestTable
from onf_website.reference.forest.model.foret import Foret, InformationForet, ProprietaireForet
from onf_website.reference.insee.model import Commune
from pyams_utils.registry import get_utility


@jsonrpc_method(endpoint='onf_website')
def findForests(request, query):
    """Forest search engine"""
    return [
        {
            'id': foret.token,
            'text': foret.title,
            'dep': foret.departement
        } for foret in
            Foret.find(query, ignore_disabled=True)
                 .order_by(Foret.libelle_strict)
    ]


@jsonrpc_method(endpoint='onf_website',
                require_csrf=False)
def findCityOrForest(request, query):
    """Search engine for forest or engine"""
    table = get_utility(IForestTable)
    communes = [{
        'id': commune.token,
        'text': commune.title,
        'dep': commune.dep,
        'order': [commune.nccenr.lower(), 1]
    } for commune in Commune.find(query)]
    forests = [{
        'id': foret.token,
        'text': info_foret.libelle or foret.title,
        'dep': foret.departement,
        'order': [foret.libelle_recherche.lower(), 2]
    } for foret, info_foret in
        Foret.find(query, ignore_disabled=True, with_info=True)
             .join(ProprietaireForet, Foret.id_nat_frt == ProprietaireForet.id_nat_frt)
             .filter(ProprietaireForet.categorie.in_(table.visible_owners_ids),
                     or_(InformationForet.visible == True,
                         InformationForet.visible == None))
    ]
    return sorted(communes + forests,
                  key=lambda x: x['order'])
