
-- Table: rdf_public.rdf_typo

CREATE TABLE rdf_public.rdf_typo
(
  unite character varying(32) NOT NULL,
  code character varying(32) NOT NULL,
  libelle character varying(255),
  CONSTRAINT rdf_typo_pkey PRIMARY KEY (unite, code)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.rdf_typo
  OWNER TO pgadm;


-- Table: rdf_public.ref_nature_detail_fic_synth

CREATE TABLE rdf_public.ref_nature_detail_fic_synth
(
    id                               INTEGER                         NOT NULL
  , code                             CHARACTER VARYING(10)
  , libelle                          CHARACTER VARYING(255)                   NOT NULL,
  CONSTRAINT ref_naturedetailficsynth_pkey PRIMARY KEY (id),
  CONSTRAINT ref_naturedetailficsynth_code UNIQUE (code)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.ref_nature_detail_fic_synth
  OWNER TO pgadm;


-- Table: rdf_public.ref_code_detail_fic_synth

CREATE TABLE rdf_public.ref_code_detail_fic_synth
(
    id                               INTEGER                         NOT NULL
  , code                             CHARACTER VARYING(10)
  , libelle                          CHARACTER VARYING(255)                   NOT NULL
  , format                           CHARACTER VARYING(10)                    NOT NULL
  , unite                            CHARACTER VARYING(10)                    NOT NULL
  , ordre_affichage                  INTEGER                         NOT NULL
  , date_debut_validite              DATE                            NOT NULL
  , date_fin_validite                DATE
  , code_nature_detail_fic_synth     CHARACTER VARYING(10)                    NOT NULL,
  CONSTRAINT ref_codedetailficsynth_pkey PRIMARY KEY (id),
  CONSTRAINT ref_codedetailficsynth_code UNIQUE (code)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.ref_code_detail_fic_synth
  OWNER TO pgadm;


-- Table: rdf_public.rdf_regroupement

CREATE TABLE rdf_public.rdf_regroupement
(
  id_nat_frt character varying(7) NOT NULL,
  date_debut_validite timestamp without time zone,
  date_fin_validite timestamp without time zone,
  cadre_legal_gestion character varying(2),
  libelle_preposition character varying(3),
  libelle_strict character varying(60),
  libelle_usage character varying(120),
  surface_cadastrale double precision,
  est_domaniale boolean,
  code_frt character varying(25),
  service_gestionnaire character(6) NOT NULL,
  code_sign character varying(6),
  commentaire character varying(250),
  date_saisie timestamp without time zone,
  frais_garderie character varying(3),
  departement character varying(5),
  centre_profit character varying(10),
  region_ifn character varying(3),
  regime character varying(2),
  date_fin_gestion timestamp without time zone,
  histo_surface_cadastrale double precision,
  histo_cadre_legal_gestion character varying(2),
  structure_rh_gestionnaire character varying(6),
  type_regroupement smallint DEFAULT 1,
  structure_rh_sign character varying(6),
  libelle_recherche character varying(60),
  CONSTRAINT rdf_regroupement_pkey PRIMARY KEY (id_nat_frt)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.rdf_regroupement
  OWNER TO pgadm;


-- Table: rdf_public.rdf_foret

CREATE TABLE rdf_public.rdf_foret
(
  id_nat_frt character varying(7) NOT NULL,
  date_debut_validite timestamp without time zone,
  date_fin_validite timestamp without time zone,
  date_expiration_contrat timestamp without time zone,
  cadre_legal_gestion character varying(2),
  libelle_preposition character varying(3),
  libelle_strict character varying(60),
  libelle_usage character varying(120),
  surface_cadastrale double precision,
  surface_retenue_gestion double precision,
  surface_sylviculture double precision,
  est_domaniale boolean,
  code_tgpe character varying(13),
  surface_tgpe double precision,
  code_frt character varying(25),
  service_gestionnaire character(6) NOT NULL,
  code_sign character varying(6),
  commentaire character varying(250),
  date_saisie timestamp without time zone,
  frais_garderie character varying(3),
  id_nat_frt_regroupement character varying(7),
  departement character varying(5),
  centre_profit character varying(10),
  region_ifn character varying(3),
  pefc_num_cert character varying(15),
  pefc_debut_cert timestamp without time zone,
  pefc_fin_cert timestamp without time zone,
  marquage_pefc boolean,
  pefc_num_marq character varying(15),
  pefc_debut_marq timestamp without time zone,
  pefc_fin_marq timestamp without time zone,
  regime character varying(2),
  date_fin_gestion timestamp without time zone,
  histo_surface_cadastrale double precision,
  structure_rh_gestionnaire character varying(6),
  histo_cadre_legal_gestion character varying(2),
  date_liaison_groupement timestamp without time zone,
  structure_rh_sign character varying(6),
  libelle_recherche character varying(60),
  CONSTRAINT rdf_foret_pkey PRIMARY KEY (id_nat_frt)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.rdf_foret
  OWNER TO pgadm;


-- Table: rdf_public.rdf_commune

CREATE TABLE rdf_public.rdf_commune
(
  id_nat_frt character varying(7) NOT NULL,
  code_insee character varying(5) NOT NULL,
  libelle_insee character varying(70),
  surface_cadastrale double precision,
  CONSTRAINT rdf_commune_pkey PRIMARY KEY (id_nat_frt, code_insee)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.rdf_commune
  OWNER TO pgadm;


-- Table: rdf_public.rdf_proprietaire

CREATE TABLE rdf_public.rdf_proprietaire
(
  id_nat_frt character varying(7) NOT NULL,
  clecli character varying(30) NOT NULL,
  categorie character varying(2),
  pourcentage_part real NOT NULL,
  type_copropriete character varying(3),
  type_lot character varying(2),
  commentaire_rdf character varying(250),
  numerateur_part bigint,
  denominateur_part bigint,
  CONSTRAINT rdf_proprietaire_pkey PRIMARY KEY (id_nat_frt, clecli)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.rdf_proprietaire
  OWNER TO pgadm;


-- Table: rdf_public.rdf_representant

CREATE TABLE rdf_public.rdf_representant
(
  id_nat_frt character varying(7) NOT NULL,
  clecli character varying(30) NOT NULL,
  categorie character varying(2),
  commentaire_rdf character varying(250),
  CONSTRAINT rdf_representant_pkey PRIMARY KEY (id_nat_frt, clecli)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.rdf_representant
  OWNER TO pgadm;


-- Table: rdf_public.region_ifn

CREATE TABLE rdf_public.region_ifn
(
  code character varying(3) NOT NULL,
  codifn character varying(4),
  libelle character varying(50),
  CONSTRAINT rdf_regionifn_pkey PRIMARY KEY (code)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rdf_public.region_ifn
  OWNER TO pgadm;
