#
# Copyright (c) 2012 Thierry Florac <tflorac AT onf.fr>
# All Rights Reserved.
#

from enum import Enum

from zope.interface import Attribute, Interface
from zope.schema import Bool, Choice, Date, Text, TextLine
from zope.schema.vocabulary import SimpleTerm, SimpleVocabulary

from onf_website import _


class IAbstractBaseForetRegroupementModel(Interface):
    """Abstract base model interface for forests and groups"""


class IAbstractBaseForetRegroupement(Interface):
    """Abstract base class interface"""

    id_nat_frt = TextLine(title=_("National ID"))
    code_frt = TextLine(title=_("National code"))
    date_saisie = Date(title=_("Creation date"))
    date_debut_validite = Date(title=_("Validity start date"))
    date_fin_validite = Date(title=_("Validity end date"))
    est_domaniale = Bool(title=_("Domanial forest?"))
    regime = TextLine(title=_("Forest regime"))
    cadre_legal_gestion = TextLine(title=_("Legal scope"))
    frais_garderie = TextLine(title=_("Keeping amounts classification"))
    libelle_usage = TextLine(title=_("Usual label"))

    inactive = Attribute("Inactive object?")


class IRegroupementModel(IAbstractBaseForetRegroupementModel):
    """Forests groups model interface"""


class IRegroupement(IAbstractBaseForetRegroupement):
    """Forest class interface"""


class IForetModel(IAbstractBaseForetRegroupementModel):
    """Forests model interface"""


class IForet(IAbstractBaseForetRegroupement):
    """Forests class interface"""


class StatutForetException(Enum):
    f = 'f',
    c = 'c',
    t = 't'


STATUT_FORET_EXCEPTION = {
    StatutForetException.f: _("No"),
    StatutForetException.c: _("Candidate"),
    StatutForetException.t: _("Yes")
}

STATUT_FORET_EXCEPTION_VOCABULARY = SimpleVocabulary([
    SimpleTerm(v, title=STATUT_FORET_EXCEPTION[v])
    for v in StatutForetException
])


class IInformationForet(Interface):
    """Custom forest information interface"""

    id_nat_frt = TextLine(title=_("National ID"))

    libelle = TextLine(title=_("Custom label"),
                       required=False)

    header = Text(title=_("Custom header"),
                  required=False)

    statut_exception = Choice(title=_("Exception forest?"),
                              description=_("If 'yes', an exception forest logo will be "
                                            "associated with this forest"),
                              required=True,
                              vocabulary=STATUT_FORET_EXCEPTION_VOCABULARY,
                              default=StatutForetException.f)

    acces_foretmapper = Bool(title=_("ForetMapper access?"),
                             description=_("If 'yes', the forest is accessible in ForetMapper "
                                           "mobile application"),
                             required=True,
                             default=False)
