#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

import re

from pyramid.events import subscriber
from pyramid.interfaces import IApplicationCreated

from onf_website.features.firebase import check_firebase_app
from onf_website.features.firebase.api import REST_SUBSCRIPTIONS_ROUTE
from onf_website.features.firebase.api.interfaces import REST_SUBSCRIPTIONS_ROUTE_DEFAULT, \
    REST_SUBSCRIPTIONS_ROUTE_SETTING
from onf_website.reference.forest.api.interfaces import REST_FORESTS_ROUTE, REST_FORESTS_ROUTE_DEFAULT, \
    REST_FORESTS_ROUTE_SETTING, REST_FORETMAPPER_ROUTE, REST_FORETMAPPER_ROUTE_DEFAULT, REST_FORETMAPPER_ROUTE_SETTING
from onf_website.shared.alert.api.interfaces import REST_ALERTS_INTERNAL_ROUTE, REST_ALERTS_INTERNAL_ROUTE_DEFAULT, \
    REST_ALERTS_INTERNAL_ROUTE_SETTING, REST_ALERT_INTERNAL_ROUTE, REST_ALERT_INTERNAL_ROUTE_DEFAULT, \
    REST_ALERT_INTERNAL_ROUTE_SETTING
from onf_website.shared.common.interfaces import REST_CONTENT_PUBLIC_GETTER_ROUTE, \
    REST_CONTENT_PUBLIC_GETTER_ROUTE_DEFAULT, REST_CONTENT_PUBLIC_GETTER_ROUTE_SETTING, \
    REST_CONTENT_PUBLIC_SEARCH_ROUTE, REST_CONTENT_PUBLIC_SEARCH_ROUTE_DEFAULT, \
    REST_CONTENT_PUBLIC_SEARCH_ROUTE_SETTING


def include_package(config):
    """Pyramid include"""

    settings = config.registry.settings

    # add translations
    config.add_translation_dirs('onf_website:locales')

    # add custom JSON-RPC endpoints
    config.add_jsonrpc_endpoint('onf_website',
                                settings.get('onf_website.api.jsonrpc_route',
                                             '/api/onf/json'))

    # add custom routes
    config.add_route('forest_access', '/+f/{id_nat_frt}*view')
    config.add_route('planning_access', '/+a/{id_nat_amgt}*view')

    # add API routes
    config.add_route(REST_SUBSCRIPTIONS_ROUTE,
                     settings.get(REST_SUBSCRIPTIONS_ROUTE_SETTING,
                                  REST_SUBSCRIPTIONS_ROUTE_DEFAULT))
    config.add_route(REST_FORESTS_ROUTE,
                     settings.get(REST_FORESTS_ROUTE_SETTING,
                                  REST_FORESTS_ROUTE_DEFAULT))
    config.add_route(REST_FORETMAPPER_ROUTE,
                     settings.get(REST_FORETMAPPER_ROUTE_SETTING,
                                  REST_FORETMAPPER_ROUTE_DEFAULT))
    config.add_route(REST_ALERTS_INTERNAL_ROUTE,
                     settings.get(REST_ALERTS_INTERNAL_ROUTE_SETTING,
                                  REST_ALERTS_INTERNAL_ROUTE_DEFAULT))
    config.add_route(REST_ALERT_INTERNAL_ROUTE,
                     settings.get(REST_ALERT_INTERNAL_ROUTE_SETTING,
                                  REST_ALERT_INTERNAL_ROUTE_DEFAULT))
    config.add_route(REST_CONTENT_PUBLIC_SEARCH_ROUTE,
                     settings.get(REST_CONTENT_PUBLIC_SEARCH_ROUTE_SETTING,
                                  REST_CONTENT_PUBLIC_SEARCH_ROUTE_DEFAULT))
    config.add_route(REST_CONTENT_PUBLIC_GETTER_ROUTE,
                     settings.get(REST_CONTENT_PUBLIC_GETTER_ROUTE_SETTING,
                                  REST_CONTENT_PUBLIC_GETTER_ROUTE_DEFAULT))

    # load registry components of overridden packages
    config.include('pyams_content')
    config.include('pyams_content_es')

    # load registry components
    try:
        import pyams_zmi
    except ImportError:
        config.scan(ignore=[re.compile('zmi').search])
    else:
        config.scan()

    if hasattr(config, 'load_zcml'):
        config.load_zcml('configure.zcml')


@subscriber(IApplicationCreated)
def handle_new_application(event):
    """Firebase initialization on application creation"""
    check_firebase_app()
