#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from lxml import etree

from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.features.html import OIDHTMLRenderer
from pyams_content.root import ISiteRootConfiguration
from pyams_skin.interfaces.configuration import IConfiguration
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces.text import IHTMLRenderer


__docformat__ = 'restructuredtext'


PICTO = '<svg xmlns:xlink="http://www.w3.org/1999/xlink" class="icon icon-external">' \
        '<use xlink:href="#icon-external"></use>' \
        '</svg>'


@adapter_config(name='oid_to_href',
                required=(str, IONFBaseLayer),
                provides=IHTMLRenderer)
class ExternalOIDHTMLRenderer(OIDHTMLRenderer):
    """Upgraded HTML renderer adding pictogram to external links"""

    def render(self):
        html = super().render(as_html=False)
        configuration = IConfiguration(self.request.root, None)
        if (configuration is None) or \
                (not ISiteRootConfiguration.providedBy(configuration)) or \
                (not configuration.public_url):
            return html.html()
        for link in html('a[href]'):
            href = link.attrib['href']
            if not href.startswith(configuration.public_url):
                try:
                    link.classes.add('external')
                except AttributeError:
                    link.attrib['class'] = 'external'
                link.append(etree.fromstring(PICTO))
        return html.html()
