#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.container.interfaces import IBTreeContainer
from zope.interface import Interface
from zope.schema import Set, TextLine
from pyams_utils.schema import PersistentDict


from onf_website import _


ACCOUNT_KEY_PATH_KEY = 'onf_website.firebase.account-key-path'
ACCOUNT_DRY_RUN_KEY = 'onf_website.firebase.dry-run'


class IFirebaseSubscription(Interface):
    """Firebase subscription interface"""

    firebase_id = TextLine(title=_("Firebase ID"),
                           required=True)

    content_types = PersistentDict(title=_("Content types"),
                                   description=_("Content types concerned by this "
                                                 "subscription"),
                                   key_type=TextLine(title=_("Content type name"),
                                                     required=True),
                                   value_type=Set(title=_("Forests IDs"),
                                                  description=_("List of forests IDs for which "
                                                                "subscription is set")),
                                   required=False)


FIREBASE_SUBSCRIPTIONS_KEY = 'onf_website.firebase.subscriptions'


class IFirebaseSubscriptions(IBTreeContainer):
    """Firebase subscriptions"""

    def add_subscriptions(self, firebase_id, content_type, forests):
        """Add subscription for given Firebase ID"""

    def drop_subscriptions(self, firebase_id, content_type=None, forests=None):
        """Drop subscriptions for given Firebase ID

        If `content_type` or `forests` are None, all subscriptions are removed.
        """

    def update_firebase_id(self, old_firebase_id, new_firebase_id):
        """Replace Firebase ID"""

    def get_subscriptions(self, content_type, forests):
        """Get list of Firebase IDs which subscribed to provided content type on one of provided forests"""
