#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Bool

from pyams_content.features.renderer import IContentRenderer


__docformat__ = 'restructuredtext'

from onf_website import _


class IHTMLParagraphCustomRenderer(IContentRenderer):
    """HTML paragraph custom renderer interface"""


HTML_PARAGRAPH_ACCORDION_RENDERER_SETTINGS_KEY = 'pyams_content.html.renderer:accordion'


class IHTMLParagraphAccordionRendererSettings(Interface):
    """HTML paragraph accordion renderer settings interface"""

    collapsed = Bool(title=_("Collapsed?"),
                     description=_("Will paragraph accordion be initially collapsed?"),
                     required=True,
                     default=True)
