#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from pyams_content.component.paragraph.portlet import IParagraphContainerPortletSettings
from pyams_default_theme.component.paragraph.portlet import ParagraphContainerPortletRenderer
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config


__docformat__ = 'restructuredtext'

from onf_website import _


@adapter_config(name='ONF::paragraphs-title-left',
                context=(IPortalContext, IPyAMSLayer, Interface,
                         IParagraphContainerPortletSettings),
                provides=IPortletRenderer)
class ParagraphContainerActivityPortletRenderer(ParagraphContainerPortletRenderer):
    """Paragraph container portlet renderer for activities"""

    label = _("ONF: Paragraphs with title in left column")

    template_name = 'PARA:title-left'
    weight = 10
