#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.skin.public import owl_carousel_init, owl_navigation
from pyams_content.component.keynumber.interfaces import IKeyNumberParagraph
from pyams_content.features.renderer.interfaces import IContentRenderer
from pyams_default_theme.component.keynumber import DefaultKeyNumberParagraphRenderer as BaseKeyNumberParagraphRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

from onf_website import _


#
#  Key numbers paragraph default renderer
#

@adapter_config(name='default',
                context=(IKeyNumberParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/keynumber-default.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/keynumber-title-left.pt', layer=IPyAMSLayer)
class DefaultKeyNumberCarouselParagraphRenderer(BaseKeyNumberParagraphRenderer):
    """Default Key Numbers renderer"""

    label = _("ONF: Default key numbers carousel")
    resources = (owl_carousel_init, owl_navigation)


@adapter_config(name='gallery',
                context=(IKeyNumberParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/keynumber-gallery.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/keynumber-title-left.pt', layer=IPyAMSLayer)
class KeyNumberGalleryParagraphRenderer(BaseKeyNumberParagraphRenderer):
    """Default Key Numbers renderer"""

    label = _("ONF: Key numbers gallery")
    weight = 2


@adapter_config(name='gallery-with-description',
                context=(IKeyNumberParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/keynumber-gallery-with-description.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/keynumber-title-left.pt', layer=IPyAMSLayer)
class KeyNumberGalleryWithDescriptionParagraphRenderer(BaseKeyNumberParagraphRenderer):
    """Default Key Numbers renderer"""

    label = _("ONF: Key numbers gallery with associated text display")
    weight = 3
