#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.schema import Bool, Choice
from zope.schema.vocabulary import SimpleVocabulary, SimpleTerm

from pyams_i18n.schema import I18nTextLineField

from onf_website import _


DESCRIPTION_UNDER_ILLUSTRATION = 'under'
DESCRIPTION_CORNER_ILLUSTRATION = 'inner_right'

DESCRIPTION_POSITIONS = (
    {'id': DESCRIPTION_CORNER_ILLUSTRATION, 'title': _("Bottom right corner")},
    {'id': DESCRIPTION_UNDER_ILLUSTRATION, 'title': _("Below illustration")}
)

DESCRIPTION_POSITIONS_VOCABULARY = SimpleVocabulary([SimpleTerm(item['id'], title=item['title'])
                                                     for item in DESCRIPTION_POSITIONS])


class IIllustrationParagraphRendererSettings(Interface):
    """Illustration paragraph default renderer settings interface"""

    display_description = Bool(title=_("Display description?"),
                               description=_("If 'no', illustration's description will not be "
                                             "displayed"),
                               required=True,
                               default=True)

    description_position = Choice(title=_("Position of associated text"),
                                  description=_("Relative position for text associated with "
                                                "illustration"),
                                  required=False,
                                  vocabulary=DESCRIPTION_POSITIONS_VOCABULARY,
                                  default=DESCRIPTION_CORNER_ILLUSTRATION)

    display_button = Bool(title=_("Display show/hide button?"),
                          description=_("If 'yes', the description will be collapsed; "
                                        "if 'no', the full associated text will be displayed"),
                          required=False,
                          default=False)

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label associated with description's "
                                                   "show/hide button"),
                                     required=False)
