#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""ONF_website.component.hearing.zmi.preview module

This module defines a custom view which can be used to handle preview of
hearing targets defining a custom source so that preview is using the
source graphical theme.

"""

__docformat__ = 'restructuredtext'

from onf_website.component.hearing import IHearingInfo, IHearingTarget
from pyams_content.shared.common.interfaces.types import IWfTypedSharedContent
from pyams_content.shared.site.interfaces import ISiteManager
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.views import PortalContextPreviewPage
from pyams_skin.layer import IPyAMSUserLayer
from pyams_skin.skin import apply_skin
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_utils.interfaces.url import DISPLAY_CONTEXT
from pyams_utils.traversing import get_parent


@pagelet_config(name='preview.html',
                context=IHearingTarget, layer=IPyAMSUserLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class HearingTargetPreviewPage(PortalContextPreviewPage):
    """Hearing target preview page"""

    def update(self):
        # Bypass publication status in preview
        hearing = IHearingInfo(self.context)
        site = None
        folder = hearing.get_source_folder()
        if (folder is None) and IWfTypedSharedContent.providedBy(self.context):
            data_type = self.context.get_data_type()
            if data_type is not None:
                folder = data_type.get_source_folder()
        if folder is not None:
            site = get_parent(folder, ISiteManager)
        if site is None:
            site = hearing.get_source_site()
        if site is not None:
            skin = site.skin
            if skin is not None:
                apply_skin(self.request, skin)
                self.request.annotations[DISPLAY_CONTEXT] = folder \
                    if folder is not None else site
        super().update()
