#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Int


__docformat__ = 'restructuredtext'

from onf_website import _
from pyams_i18n.schema import I18nTextLineField


class IGalleryPortletMosaicRendererSettings(Interface):
    """Gallery portlet mosaic renderer settings interface"""

    thumbnails_count = Int(title=_("Thumbnails count"),
                           description=_("Number of gallery images displayed as thumbnails"),
                           required=True,
                           default=6)

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label displayed on button used to display "
                                                   "all gallery images"),
                                     required=True)
