#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from pyramid.i18n import TranslationStringFactory
_ = TranslationStringFactory('onf_website')


def includeme(config):
    """Pyramid include"""

    from .include import include_package
    include_package(config)

    from onf_website.shared.forest.interfaces import MANAGE_FOREST_PERMISSION

    # register custom permissions
    config.register_permission({
        'id': MANAGE_FOREST_PERMISSION,
        'title': _("Manage forest content")
    })
